@echo off

: This is ExtensionPack Assistant 0.5
: Last Change 05 2006 - Simon Hutter
: This File is provided under GNU GPL
: The Assistant uses 7zip, licensed under GNU LGPL, see www.7-zip.org

cls

echo      Welcome to the ExtensionPack Assistant
echo ------------------------------------------------
echo.
echo Please chose the Extensions you want to include.
echo    ([n]=don't include, anything else=include)
echo.

:: Define all Variables (if not, no input will cause the Assistant to crash)
set adblo=y
set afilup=y
set custgoog=y
set downmantw=y
set fastfox=y
set opboo=y
set pdfdown=y
set seo=y
set smowhe=y
set sorlb=y
set tabmi=y


:: Ask User
set /p adblo=AdBlock 
set /p afilup=AdBlock Filterset G Updater 
set /p custgoog=CustomizeGoogle 
set /p downmantw=Download Manager Tweak 
set /p fastfox=Fasterfox 
set /p opboo=OpenBook 
set /p pdfdown=PDF Download 
set /p seo=Search Engine Ordering 
set /p smowhe=SmoothWheel 
set /p sorlb=Stop or Reload Button 
set /p tabmi=Tab Mix Plus 


echo.
echo.
echo Please wait...
echo.
echo --------------------------------------------------------------------------------
echo Copying data...


if exist extpack.tmp rmdir extpack.tmp /S /Q
@mkdir extpack.tmp 
@copy "core\extensions\install.rdf" "extpack.tmp\install.rdf"


:: Copy the chosen Extensions into the Temp Folder

@If not %adblo%==n copy "core\extensions\AdBlock.xpi" "extpack.tmp\AdBlock.xpi"
@If not %afilup%==n copy "core\extensions\AdBlock Filterset G Updater.xpi" "extpack.tmp\AdBlock Filterset G Updater.xpi"
@If not %custgoog%==n copy "core\extensions\CustomizeGoogle.xpi" "extpack.tmp\CustomizeGoogle.xpi"
@If not %downmantw%==n copy "core\extensions\Download Manager Tweak.xpi" "extpack.tmp\Download Manager Tweak.xpi"
@If not %fastfox%==n copy "core\extensions\Fasterfox.xpi" "extpack.tmp\Fasterfox.xpi"
@If not %opboo%==n copy "core\extensions\OpenBook.xpi" "extpack.tmp\OpenBook.xpi"
@If not %pdfdown%==n copy "core\extensions\PDF Download.xpi" "extpack.tmp\PDF Download.xpi"
@If not %seo%==n copy "core\extensions\SearchEngineOrdering.xpi" "extpack.tmp\SearchEngineOrdering.xpi"
@If not %smowhe%==n copy "core\extensions\SmoothWheel.xpi" "extpack.tmp\SmoothWheel.xpi"
@If not %sorlb%==n copy "core\extensions\stop or reload button.xpi" "extpack.tmp\stop or reload button.xpi"
@If not %tabmi%==n copy "core\extensions\Tab Mix Plus.xpi" "extpack.tmp\Tab Mix Plus.xpi"




:: Create ExtensionPack

echo.
echo Zipping files...

if not exist ExtensionPack_MyOwn.xpi goto nonumber
set exist=1

:checkexist
If exist ExtensionPack_MyOwn_%exist%.xpi goto addexist
goto pack

:addexist
set /a exist+=1
goto checkexist

:pack
@core\7za.exe a -tzip ExtensionPack_MyOwn_%exist%.xpi .\extpack.tmp\*
goto delfol

:nonumber
@core\7za.exe a -tzip ExtensionPack_MyOwn.xpi .\extpack.tmp\*

:delfol
echo.
echo Deleting Temp Files...
rmdir extpack.tmp /S /Q


echo.
echo --------------------------------------------------------------------------------
echo.
echo Your Own Extension Pack was created.
echo.
set /p end=Press [Enter] to close this assistant.


